/*
 * Copyright 2019 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _PDE_PRIVATE_H_
#define _PDE_PRIVATE_H_

#define PDE_DEBUG_GFSK_PACKET_TIMING    (0)
#define PDE_DEBUG_START_CAL_TIMING      (0)
#define PDE_DEBUG_IQ_CAPTURE_TIMING     (0)
#define PDE_DEBUG_DC_MD                 (0)
#define PDE_DEBUG_DC_RD                 (0)

/* GPIO Debug */
#define D0_SET()            GPIOA->PSOR |= (1U<<16U) /* PTA16 J2-1 */
#define D0_CLEAR()          GPIOA->PCOR |= (1U<<16U)
#define D0_TOGGLE()         GPIOA->PTOR |= (1U<<16U)

#define D1_SET()            GPIOC->PSOR |= (1U<<19U) /* PTC19 J1-3 */
#define D1_CLEAR()          GPIOC->PCOR |= (1U<<19U)
#define D1_TOGGLE()         GPIOC->PTOR |= (1U<<19U)

#define D2_SET()            GPIOC->PSOR |= (1U<<3U) /* PTC3 J1-4 */
#define D2_CLEAR()          GPIOC->PCOR |= (1U<<3U)
#define D2_TOGGLE()         GPIOC->PTOR |= (1U<<3U)

#define D3_SET()            GPIOB->PSOR |= (1U<<2U) /* J4.3 */
#define D3_CLEAR()          GPIOB->PCOR |= (1U<<2U)
#define D3_TOGGLE()         GPIOB->PTOR |= (1U<<2U)

#define D4_SET()            GPIOB->PSOR |= (1U<<3U) /* J4.4 */
#define D4_CLEAR()          GPIOB->PCOR |= (1U<<3U)
#define D4_TOGGLE()         GPIOB->PTOR |= (1U<<3U)

#define D5_SET()            GPIOC->PSOR |= (1U<<1U) /* J2.2 */
#define D5_CLEAR()          GPIOC->PCOR |= (1U<<1U)
#define D5_TOGGLE()         GPIOC->PTOR |= (1U<<1U)

#define PDE_DEBUG_TIMING                 0
#if PDE_DEBUG_TIMING
    #define DBG_TIMING_TX_START()                         D0_SET()
    #define DBG_TIMING_TX_STOP()                          D0_CLEAR()
    #define DBG_TIMING_TX_TOGGLE()                        D0_TOGGLE()

    #define DBG_TIMING_RX_START()                         D4_SET()
    #define DBG_TIMING_RX_STOP()                          D4_CLEAR()
    #define DBG_TIMING_RX_TOGGLE()                        D4_TOGGLE()

    #define DBG_TIMING_DMA_START()                        D2_SET()
    #define DBG_TIMING_DMA_STOP()                         D2_CLEAR()

    #define DBG_TIMING_TPM_IRQ_HANDLER_START()            D3_SET()
    #define DBG_TIMING_TPM_IRQ_HANDLER_STOP()             D3_CLEAR()
    
    #define DBG_TIMING_TOGGLE_ALL()                       do { D0_TOGGLE(); D4_TOGGLE(); D2_TOGGLE(); D3_TOGGLE(); } while(0==1)
#else
    #define DBG_TIMING_TX_START()                         do { } while(0==1)
    #define DBG_TIMING_TX_STOP()                          do { } while(0==1)
    #define DBG_TIMING_TX_TOGGLE()                        do { } while(0==1)

    #define DBG_TIMING_RX_START()                         do { } while(0==1)
    #define DBG_TIMING_RX_STOP()                          do { } while(0==1)
    #define DBG_TIMING_RX_TOGGLE()                        do { } while(0==1)

    #define DBG_TIMING_DMA_START()                        do { } while(0==1)
    #define DBG_TIMING_DMA_STOP()                         do { } while(0==1)

    #define DBG_TIMING_TPM_IRQ_HANDLER_START()            do { } while(0==1)
    #define DBG_TIMING_TPM_IRQ_HANDLER_STOP()             do { } while(0==1)

    #define DBG_TIMING_TOGGLE_ALL()                       do { } while(0==1)
#endif

#ifndef NOT_USED
#define NOT_USED(__x) (void)(__x)
#endif

#endif //_PDE_PRIVATE_H_
